export default function DSAR() {
  return (
    <main className="container mx-auto px-6 py-10">
      <h1 className="text-3xl font-bold mb-6">Data Subject Access Request (DSAR)</h1>
      <form method="POST" action="/api/dsar" className="grid gap-4 max-w-xl">
        <label className="grid gap-1">
          <span>Name</span>
          <input name="name" required className="border p-2 rounded"/>
        </label>
        <label className="grid gap-1">
          <span>Email</span>
          <input type="email" name="email" required className="border p-2 rounded"/>
        </label>
        <label className="grid gap-1">
          <span>Country</span>
          <input name="country" required className="border p-2 rounded"/>
        </label>
        <label className="grid gap-1">
          <span>Request Type</span>
          <select name="type" required className="border p-2 rounded">
            <option value="access">Access / Copy of Data</option>
            <option value="rectify">Rectification</option>
            <option value="delete">Deletion</option>
            <option value="restrict">Restriction</option>
            <option value="portability">Portability</option>
            <option value="objection">Objection</option>
          </select>
        </label>
        <label className="grid gap-1">
          <span>Details</span>
          <textarea name="details" rows="5" className="border p-2 rounded"/>
        </label>
        <label className="flex items-center gap-2">
          <input type="checkbox" name="consent" required />
          <span>I have read and agree to the <a href="/legal/terms-of-service" target="_blank" className="underline">Terms of Service</a> and <a href="/legal/privacy-policy" target="_blank" className="underline">Privacy Policy</a>.</span>
        </label>
        <button type="submit" className="p-3 rounded bg-black text-white">Submit Request</button>
      </form>
    </main>
  );
}
