import fs from 'fs';
import path from 'path';

export async function getStaticProps() {
  const filePath = path.join(process.cwd(), 'content', 'terms-of-service.md');
  const content = fs.readFileSync(filePath, 'utf8');
  return { props: { content } };
}

export default function TermsOfService({ content }) {
  return (
    <main className="container mx-auto px-6 py-10 prose">
      <div dangerouslySetInnerHTML={{ __html: content.replace(/\n/g, '<br/>') }} />
    </main>
  );
}
