import { useEffect, useState } from 'react';

export default function CookieBanner() {
  const [visible, setVisible] = useState(false);

  useEffect(() => {
    const consent = localStorage.getItem('cookie_consent_v1');
    if (!consent) setVisible(true);
  }, []);

  const acceptAll = () => {
    localStorage.setItem('cookie_consent_v1', 'all');
    setVisible(false);
    if (typeof window !== 'undefined' && window.initAnalytics) window.initAnalytics();
  };

  const rejectNonEssential = () => {
    localStorage.setItem('cookie_consent_v1', 'essential');
    setVisible(false);
  };

  if (!visible) return null;
  return (
    <div style={{position:'fixed',left:0,right:0,bottom:0,background:'#111',color:'#fff',padding:'12px',zIndex:9999}}>
      <div style={{display:'flex',gap:'8px',alignItems:'center',justifyContent:'space-between'}}>
        <span>We use cookies to enhance your experience. Manage your preferences.</span>
        <div style={{display:'flex',gap:'8px'}}>
          <button onClick={acceptAll}>Accept All</button>
          <button onClick={rejectNonEssential}>Reject Non‑Essential</button>
          <button onClick={() => alert('Open cookie settings modal here')}>Settings</button>
        </div>
      </div>
    </div>
  );
}
