# Xyberteq GDPR Web Pack (Next.js drop-in)

## What this contains
- /content/terms-of-service.md (customised for Xyberteq Innovations Sdn. Bhd.)
- /content/privacy-policy.md (web version)
- /pages/legal/privacy-policy.jsx (renders MD as HTML)
- /pages/legal/terms-of-service.jsx (renders MD as HTML)
- /pages/privacy/request.jsx (DSAR form)
- /pages/api/dsar.js (DSAR email handler via SMTP)
- /components/CookieBanner.jsx (consent gating)
- /lib/consent.js
- /public/js/analytics-init.js (init analytics only after consent)
- /pages/_app.jsx (injects banner + footer links)
- /.env.example (mail settings)

## How to add to your Next.js site
1. Copy the folders into your repo.
2. Install dependencies: `npm i nodemailer`
3. Create `.env.local` from `.env.example` and fill SMTP creds.
4. Deploy. Ensure /privacy/request works and emails are sent.
5. Update EU Representative details in /content/privacy-policy.md once appointed.
6. If you prefer server-side DSAR persistence, plug in your DB/Sheets in /pages/api/dsar.js (marked TODO).

## Analytics
- Only initialize analytics after consent === 'all' (see /public/js/analytics-init.js and CookieBanner).
